/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package citas2term;

import java.util.ArrayList;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

/**
 *
 * @author Miguel Carvalho 
 */
public class Autor
{
    String nome;
    LocalDate nascimento;
    LocalDate morte;
    Biografia bio;
    ArrayList<Citacao> citacoes = new ArrayList<Citacao>();
	
    Autor(String nome)
    {
    	this.nome = nome;
    }
    
    String get_nome()
    {
        return nome;
    }
	
    void set_nascimento(String data) 
    {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("dd/MM/yyyy");
         
        //string to date
        nascimento = LocalDate.parse(data, dateTimeFormatter);
    }
	
    LocalDate get_nascimento()
    {
	return(nascimento);
    }
        
    void set_morte(String data) 
    {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("dd/MM/yyyy");
         
        //string to date
            morte = LocalDate.parse(data, dateTimeFormatter);
    }
	
    LocalDate get_morte()
    {
        return(morte);
    }
	
    void set_biografia(String biog, Autor escritor)
    {
        bio = new Biografia(biog, escritor);
    }
        
    void remove_biografia()
    {
        bio = null;
    }
	
    String get_biografia()
    {
        return(bio.get_biografia());
    }
	
    void add_citacao(Citacao entrada)
    {
        citacoes.add(entrada);
    }
        
    int get_citacao(String texto)
    {
        int i;
            
        for(i=0; i< citacoes.size(); i++)
            if(citacoes.get(i).get_texto().compareTo(texto)==0)
                return(i);
            
        return(-1);
    }
    
    Citacao get_citacao(int i)
    {
        return(citacoes.get(i));
    }
	
    void remove_citacao(String texto)
    {
         citacoes.remove(get_citacao(texto));
    }
        
    int get_comprimento_lista_citacoes()
    {
        return(citacoes.size());
    }
}