/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package citas2term;

/**
 *
 * @author Miguel Carvalho
 */
import java.util.Scanner;
import java.util.HashMap;
import java.util.ArrayList;

/**
 *
 * @author Miguel Carvalho
 */


class Processing//funcoes de processamento  
{   
    Citacao na_lista(ArrayList<Citacao> lista, String cita)
    {
        for(int i = 0; i<lista.size(); i++)
            if(lista.get(i).texto.compareToIgnoreCase(cita)==0)
                return(lista.get(i));
        
        return null;
    }
    
    void introduduzir_citacao(ArrayList<Citacao> lista_citacoes, HashMap<String, Autor> autores, String texto, String escritor)
    {
        Autor autor;
        
        if(na_lista(lista_citacoes, texto) == null)
        {
            if(autores.get(escritor) == null)
            {
                autor = new Autor(escritor);
                autores.put(escritor, autor);
            }
            
            else
                autor = autores.get(escritor);
                
            Citacao cita = new Citacao(texto, autor);
            
            lista_citacoes.add(cita);
            autores.get(escritor).add_citacao(cita);
        }
            
        else
            System.out.print("Erro: Citação já contida na base de dados!\n\n");
    }
    
    void remover_citacao(ArrayList<Citacao> lista_citacoes, HashMap<String, Autor> autores, String texto, String escritor)
    {
        Citacao c = na_lista(lista_citacoes, texto);
                
        if(c != null && c.get_autor().nome.contentEquals(escritor))
        {
            lista_citacoes.remove(c);
                
            autores.get(escritor).remove_citacao(texto);
            
            if( autores.get(escritor).get_comprimento_lista_citacoes()==0)
                autores.remove(escritor);
        }
        
        else
            System.out.print("Erro: Citação não encontrada na base de dados!\n\n");
    }
    
    void remover_autor(HashMap<String, Autor> autores, String escritor)
    {
        if(autores.get(escritor)!=null)
            autores.remove(escritor);
        
        else
           System.out.print("Erro: Autor não encontrado na base de dados!\n\n"); 
    }
    
    int listar_citacoes(ArrayList<Citacao> lista_citacoes)
    {
        int i;
        
        System.out.print("\n\n\nLista de citações\n");
        
        for(i=0; i<lista_citacoes.size(); i++)
            System.out.println("\n\n" + (i+1) + ") " + lista_citacoes.get(i).get_texto() + "\n\n\t\t" + lista_citacoes.get(i).get_autor().get_nome());
        
        if(lista_citacoes.isEmpty())
        {
            System.out.println("\n\n\n --------------------- Nada a mostrar ---------------------- ");
        
            System.out.print("\n\n\n Carregue na tecla Enter para continuar...");
            
            try
            {         
                System.in.read();
            }
            
            catch(Exception e)
            {
                System.out.print("\n\n\nErro: Ocorreu uma excepção. Porque aconteceu? Boa pergunta! Googla.");
            }
        }
        
        return(lista_citacoes.size());
    }
    
    void listar_citacao(ArrayList<Citacao> lista_citacoes, String texto)
    {
      Citacao cita = na_lista(lista_citacoes, texto);
        
      System.out.println("\n\n\nCitação:\n\n\n" + cita.get_texto() +"\n\n\t\t" + cita.get_autor());
    }
            
    void listar_autores(HashMap<String, Autor> autores)
    {   
        int i;
        
        System.out.println("\n\n\nLista de autores\n");
        
        i = 0;
           
        for (Autor aut : autores.values()) 
        {
            i++;
            
            System.out.println("\n" + i + ") " + aut.nome);
        }
                
        if(autores.isEmpty())
        {
            System.out.println("\n\n --------------------- Nada a mostrar ---------------------- ");
        
            System.out.print("\n\n\n Carregue na tecla Enter para continuar...");
            
            try
            {         
                System.in.read();
            }
            
            catch(Exception e)
            {
                System.out.print("\n\n\nErro: Ocorreu uma excepção. Porque aconteceu? Boa pergunta! Googla.");
            }
        }
    }
    
    void listar_autor(HashMap<String, Autor> autores, String escritor)
    {
        Autor aut;
        int i;
        
        aut = autores.get(escritor);
        
        System.out.println("Autor: " + aut.nome + "\n\n Lista de Citações:\n\n ");
        
        for(i=0; i< aut.get_comprimento_lista_citacoes(); i++)
            System.out.println("Citacao " + i+1 + ": " + aut.get_citacao(i).texto);
    }
            
}

public class Citas2Term 
{ 
    ArrayList<Citacao> lista_citacoes = new ArrayList<>();
    HashMap<String, Autor> autores = new HashMap<>();
    Processing processing = new Processing();
    Scanner sca = new Scanner(System.in);
    
    
   int menu_principal()
   {
       int op;
       
       System.out.print("\n\n\n\n\nCitas 2 Para Terminal Ultra Extra Deluxe Edition 1.0\n\nMenu principal\n\n\n1) Adicionar pensamento\n2) Eliminar pensamento\n\n3) Listar Pensamentos\n4) Listar autores\n\n0) Sair\n\n\nEscolha: ");
        
       op = sca.nextInt();
       
       return(op); 
   }
   
   void menu_adicionar_citacao()
   {
       String cita, autor;
       int op;
       
       sca.nextLine();
       
       System.out.print("\n\n\nMenu para adicionar um pensamento\n\nPensamento: ");
       cita = sca.nextLine();
       
       System.out.print("Autor: ");
       autor = sca.nextLine();
       
       op = menu3();
       
       if(op==1)
           processing.introduduzir_citacao(lista_citacoes, autores, cita, autor);
   }
    
   int menu3()
   {
       int op;
       
       System.out.print("\n\n\nDeseja realmente realizar este comando?\n\n1) Sim 2) Nao\n\n\nEscolha: ");
        
       op = sca.nextInt();
       
       return(op); 
   }
   
   int menu_final()
   {
       int op;
       
       System.out.print("\n\n\nDeseja voltar ao menu principal?\n\n\n1) Sim 2) Nao\n\n\n\nEscolha: ");
        
       op = sca.nextInt();
       
       return(op); 
   }
   
   void menu_eliminar_citacao()
   {
       int op, op2, n;
       
       System.out.print("\n\n\nMenu para eliminar um pensamento");
       
       processing.listar_citacoes(lista_citacoes);
       
       System.out.print("\n\nEscolha citacao a eliminar: ");
      
       op = sca.nextInt();
       
       op2 = menu3();
       
       if(op2==1)
           processing.remover_citacao(lista_citacoes, autores, lista_citacoes.get(op-1).get_texto(), lista_citacoes.get(op-1).get_autor().get_nome());
   }
   
   void menu_listar_citas()
   {
       processing.listar_citacoes(lista_citacoes);
   }
   
    void menu_listar_autores()
   {
       processing.listar_autores(autores);
   }
   
   void input()
   {
       int op, op2;
       
       do
       {
         op = menu_principal();
         
         switch(op)
         {
             case 1: menu_adicionar_citacao();
                     break;
             
             case 2: menu_eliminar_citacao();
                     break;   
                 
             case 3: menu_listar_citas();
             
                    System.out.print("\n\n\n Carregue na tecla Enter para continuar...");
             
                     try
                     {         
                        System.in.read();
                     }
            
                     catch(Exception e)
                     {
                        System.out.print("\n\n\nErro: Ocorreu uma excepção. Porque aconteceu? Boa pergunta! Googla.");
                     }
                    break;
                 
             case 4: menu_listar_autores();
             
                    System.out.print("\n\n\n Carregue na tecla Enter para continuar...");
             
                    try
                     {         
                        System.in.read();
                     }
            
                     catch(Exception e)
                     {
                        System.out.print("\n\n\nErro: Ocorreu uma excepção. Porque aconteceu? Boa pergunta! Googla.");
                     }
                    break;
                 
             case 0: break;
                 
             default: System.out.println("Erro: escolha nao reconhecida!");
         }
           
       }
       while(op!=0);         
   }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) 
    {
        Citas2Term citas = new Citas2Term();
        
        citas.input();
    }
}
